"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tag_manager_1 = require("./tag-manager");
/**
 * The common functionality for Tag and Remove Tag Aspects
 */
class TagBase {
    constructor(key, props = {}) {
        this.key = key;
        this.props = props;
    }
    visit(construct) {
        if (tag_manager_1.TagManager.isTaggable(construct)) {
            this.applyTag(construct);
        }
    }
}
/**
 * The Tag Aspect will handle adding a tag to this node and cascading tags to children
 */
class Tag extends TagBase {
    constructor(key, value, props = {}) {
        super(key, props);
        this.defaultPriority = 100;
        if (value === undefined) {
            throw new Error('Tag must have a value');
        }
        this.value = value;
    }
    /**
     * add tags to the node of a construct and all its the taggable children
     */
    static add(scope, key, value, props = {}) {
        scope.node.applyAspect(new Tag(key, value, props));
    }
    /**
     * remove tags to the node of a construct and all its the taggable children
     */
    static remove(scope, key, props = {}) {
        scope.node.applyAspect(new RemoveTag(key, props));
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.setTag(this.key, this.value, this.props.priority !== undefined ? this.props.priority : this.defaultPriority, this.props.applyToLaunchedInstances !== false);
        }
    }
}
exports.Tag = Tag;
/**
 * The RemoveTag Aspect will handle removing tags from this node and children
 */
class RemoveTag extends TagBase {
    constructor(key, props = {}) {
        super(key, props);
        this.defaultPriority = 200;
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.removeTag(this.key, this.props.priority !== undefined ? this.props.priority : this.defaultPriority);
        }
    }
}
exports.RemoveTag = RemoveTag;
//# sourceMappingURL=data:application/json;base64,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