"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
        });
    }
    addFileAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesizeStackArtifacts(session) {
        _shared_1.assertBound(this.stack);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        _shared_1.addStackArtifactToAssembly(session, this.stack, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
            requiresBootstrapStackVersion: 1,
        }, []);
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
//# sourceMappingURL=data:application/json;base64,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