"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RemovalPolicy;
(function (RemovalPolicy) {
    /**
     * This is the default removal policy. It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    RemovalPolicy["DESTROY"] = "destroy";
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained
     * in the account, but orphaned from the stack.
     */
    RemovalPolicy["RETAIN"] = "retain";
    /**
     * This retention policy deletes the resource,
     * but saves a snapshot of its data before deleting,
     * so that it can be re-created later.
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    RemovalPolicy["SNAPSHOT"] = "snapshot";
})(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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