"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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