"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class CfnCondition extends cfn_element_1.CfnElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression,
            },
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.CfnCondition = CfnCondition;
//# sourceMappingURL=data:application/json;base64,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