"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources
 */
var CfnCapabilities;
(function (CfnCapabilities) {
    /**
     * No IAM Capabilities
     *
     * Pass this capability if you wish to block the creation IAM resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["NONE"] = "";
    /**
     * Capability to create anonymous IAM resources
     *
     * Pass this capability if you're only creating anonymous resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["ANONYMOUS_IAM"] = "CAPABILITY_IAM";
    /**
     * Capability to create named IAM resources.
     *
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     *
     * `CloudFormationCapabilities.NamedIAM` implies `CloudFormationCapabilities.IAM`; you don't have to pass both.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /**
     * Capability to run CloudFormation macros
     *
     * Pass this capability if your template includes macros, for example AWS::Include or AWS::Serverless.
     *
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     */
    CfnCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(CfnCapabilities = exports.CfnCapabilities || (exports.CfnCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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