"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 *
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectly.
 *
 * @default FIRE_AND_FORGET
 */
var ServiceIntegrationPattern;
(function (ServiceIntegrationPattern) {
    /**
     * Call a service and progress to the next state immediately after the API call completes
     */
    ServiceIntegrationPattern["FIRE_AND_FORGET"] = "FIRE_AND_FORGET";
    /**
     * Call a service and wait for a job to complete.
     */
    ServiceIntegrationPattern["SYNC"] = "SYNC";
    /**
     * Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with paylaod
     */
    ServiceIntegrationPattern["WAIT_FOR_TASK_TOKEN"] = "WAIT_FOR_TASK_TOKEN";
})(ServiceIntegrationPattern = exports.ServiceIntegrationPattern || (exports.ServiceIntegrationPattern = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RlcC1mdW5jdGlvbnMtdGFzay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0ZXAtZnVuY3Rpb25zLXRhc2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUEyRUE7Ozs7Ozs7R0FPRztBQUNILElBQVkseUJBYVg7QUFiRCxXQUFZLHlCQUF5QjtJQUNqQzs7T0FFRztJQUNILGdFQUFtQyxDQUFBO0lBQ25DOztPQUVHO0lBQ0gsMENBQWEsQ0FBQTtJQUNiOztPQUVHO0lBQ0gsd0VBQTJDLENBQUE7QUFDL0MsQ0FBQyxFQWJXLHlCQUF5QixHQUF6QixpQ0FBeUIsS0FBekIsaUNBQXlCLFFBYXBDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tIFwiLi4vLi4vYXdzLWNsb3Vkd2F0Y2hcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJ1xuaW1wb3J0ICogYXMgaWFtIGZyb20gXCIuLi8uLi9hd3MtaWFtXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtaWFtJ1xuaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IFRhc2sgfSBmcm9tICcuL3N0YXRlcy90YXNrJztcbi8qKlxuICogSW50ZXJmYWNlIGZvciByZXNvdXJjZXMgdGhhdCBjYW4gYmUgdXNlZCBhcyB0YXNrc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIElTdGVwRnVuY3Rpb25zVGFzayB7XG4gICAgLyoqXG4gICAgICogQ2FsbGVkIHdoZW4gdGhlIHRhc2sgb2JqZWN0IGlzIHVzZWQgaW4gYSB3b3JrZmxvd1xuICAgICAqL1xuICAgIGJpbmQodGFzazogVGFzayk6IFN0ZXBGdW5jdGlvbnNUYXNrQ29uZmlnO1xufVxuLyoqXG4gKiBQcm9wZXJ0aWVzIHRoYXQgZGVmaW5lIHdoYXQga2luZCBvZiB0YXNrIHNob3VsZCBiZSBjcmVhdGVkXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RlcEZ1bmN0aW9uc1Rhc2tDb25maWcge1xuICAgIC8qKlxuICAgICAqIFRoZSByZXNvdXJjZSB0aGF0IHJlcHJlc2VudHMgdGhlIHdvcmsgdG8gYmUgZXhlY3V0ZWRcbiAgICAgKlxuICAgICAqIEVpdGhlciB0aGUgQVJOIG9mIGEgTGFtYmRhIEZ1bmN0aW9uIG9yIEFjdGl2aXR5LCBvciBhIHNwZWNpYWxcbiAgICAgKiBBUk4uXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzb3VyY2VBcm46IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBQYXJhbWV0ZXJzIHBhc3MgYSBjb2xsZWN0aW9uIG9mIGtleS12YWx1ZSBwYWlycywgZWl0aGVyIHN0YXRpYyB2YWx1ZXMgb3IgSlNPTlBhdGggZXhwcmVzc2lvbnMgdGhhdCBzZWxlY3QgZnJvbSB0aGUgaW5wdXQuXG4gICAgICpcbiAgICAgKiBUaGUgbWVhbmluZyBvZiB0aGVzZSBwYXJhbWV0ZXJzIGlzIHRhc2stZGVwZW5kZW50LlxuICAgICAqXG4gICAgICogSXRzIHZhbHVlcyB3aWxsIGJlIG1lcmdlZCB3aXRoIHRoZSBgcGFyYW1ldGVyc2AgcHJvcGVydHkgd2hpY2ggaXMgY29uZmlndXJlZCBkaXJlY3RseVxuICAgICAqIG9uIHRoZSBUYXNrIHN0YXRlLlxuICAgICAqXG4gICAgICogQHNlZVxuICAgICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zdGVwLWZ1bmN0aW9ucy9sYXRlc3QvZGcvaW5wdXQtb3V0cHV0LWlucHV0cGF0aC1wYXJhbXMuaHRtbCNpbnB1dC1vdXRwdXQtcGFyYW1ldGVyc1xuICAgICAqXG4gICAgICogQGRlZmF1bHQgTm8gcGFyYW1ldGVyc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhcmFtZXRlcnM/OiB7XG4gICAgICAgIFtuYW1lOiBzdHJpbmddOiBhbnk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBNYXhpbXVtIHRpbWUgYmV0d2VlbiBoZWFydCBiZWF0c1xuICAgICAqXG4gICAgICogSWYgdGhlIHRpbWUgYmV0d2VlbiBoZWFydCBiZWF0cyB0YWtlcyBsb25nZXIgdGhhbiB0aGlzLCBhICdUaW1lb3V0JyBlcnJvciBpcyByYWlzZWQuXG4gICAgICpcbiAgICAgKiBUaGlzIGlzIG9ubHkgcmVsZXZhbnQgd2hlbiB1c2luZyBhbiBBY3Rpdml0eSB0eXBlIGFzIHJlc291cmNlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgTm8gaGVhcnQgYmVhdCB0aW1lb3V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgaGVhcnRiZWF0PzogRHVyYXRpb247XG4gICAgLyoqXG4gICAgICogQWRkaXRpb25hbCBwb2xpY3kgc3RhdGVtZW50cyB0byBhZGQgdG8gdGhlIGV4ZWN1dGlvbiByb2xlXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBObyBwb2xpY3kgcm9sZXNcbiAgICAgKi9cbiAgICByZWFkb25seSBwb2xpY3lTdGF0ZW1lbnRzPzogaWFtLlBvbGljeVN0YXRlbWVudFtdO1xuICAgIC8qKlxuICAgICAqIFByZWZpeCBmb3Igc2luZ3VsYXIgbWV0cmljIG5hbWVzIG9mIGFjdGl2aXR5IGFjdGlvbnNcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IE5vIHN1Y2ggbWV0cmljc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IG1ldHJpY1ByZWZpeFNpbmd1bGFyPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFByZWZpeCBmb3IgcGx1cmFsIG1ldHJpYyBuYW1lcyBvZiBhY3Rpdml0eSBhY3Rpb25zXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBObyBzdWNoIG1ldHJpY3NcbiAgICAgKi9cbiAgICByZWFkb25seSBtZXRyaWNQcmVmaXhQbHVyYWw/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGRpbWVuc2lvbnMgdG8gYXR0YWNoIHRvIG1ldHJpY3NcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IE5vIG1ldHJpY3NcbiAgICAgKi9cbiAgICByZWFkb25seSBtZXRyaWNEaW1lbnNpb25zPzogY2xvdWR3YXRjaC5EaW1lbnNpb25IYXNoO1xufVxuLyoqXG4gKiBUaHJlZSB3YXlzIHRvIGNhbGwgYW4gaW50ZWdyYXRlZCBzZXJ2aWNlOiBSZXF1ZXN0IFJlc3BvbnNlLCBSdW4gYSBKb2IgYW5kIFdhaXQgZm9yIGEgQ2FsbGJhY2sgd2l0aCBUYXNrIFRva2VuLlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2Nvbm5lY3QtdG8tcmVzb3VyY2UuaHRtbFxuICpcbiAqIEhlcmUsIHRoZXkgYXJlIG5hbWVkIGFzIEZJUkVfQU5EX0ZPUkdFVCwgU1lOQyBhbmQgV0FJVF9GT1JfVEFTS19UT0tFTiByZXNwZWN0bHkuXG4gKlxuICogQGRlZmF1bHQgRklSRV9BTkRfRk9SR0VUXG4gKi9cbmV4cG9ydCBlbnVtIFNlcnZpY2VJbnRlZ3JhdGlvblBhdHRlcm4ge1xuICAgIC8qKlxuICAgICAqIENhbGwgYSBzZXJ2aWNlIGFuZCBwcm9ncmVzcyB0byB0aGUgbmV4dCBzdGF0ZSBpbW1lZGlhdGVseSBhZnRlciB0aGUgQVBJIGNhbGwgY29tcGxldGVzXG4gICAgICovXG4gICAgRklSRV9BTkRfRk9SR0VUID0gJ0ZJUkVfQU5EX0ZPUkdFVCcsXG4gICAgLyoqXG4gICAgICogQ2FsbCBhIHNlcnZpY2UgYW5kIHdhaXQgZm9yIGEgam9iIHRvIGNvbXBsZXRlLlxuICAgICAqL1xuICAgIFNZTkMgPSAnU1lOQycsXG4gICAgLyoqXG4gICAgICogQ2FsbCBhIHNlcnZpY2Ugd2l0aCBhIHRhc2sgdG9rZW4gYW5kIHdhaXQgdW50aWwgdGhhdCB0b2tlbiBpcyByZXR1cm5lZCBieSBTZW5kVGFza1N1Y2Nlc3MvU2VuZFRhc2tGYWlsdXJlIHdpdGggcGF5bGFvZFxuICAgICAqL1xuICAgIFdBSVRfRk9SX1RBU0tfVE9LRU4gPSAnV0FJVF9GT1JfVEFTS19UT0tFTidcbn1cbiJdfQ==