"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Suffixes corresponding to different service integration patterns
 *
 * Key is the service integration pattern, value is the resource ARN suffix.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 */
const resourceArnSuffix = new Map();
resourceArnSuffix.set(sfn.ServiceIntegrationPattern.FIRE_AND_FORGET, '');
resourceArnSuffix.set(sfn.ServiceIntegrationPattern.SYNC, '.sync');
resourceArnSuffix.set(sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN, '.waitForTaskToken');
function getResourceArn(service, api, integrationPattern) {
    if (!service || !api) {
        throw new Error("Both 'service' and 'api' must be provided to build the resource ARN.");
    }
    return `arn:${core_1.Aws.PARTITION}:states:::${service}:${api}` +
        (integrationPattern ? resourceArnSuffix.get(integrationPattern) : '');
}
exports.getResourceArn = getResourceArn;
//# sourceMappingURL=data:application/json;base64,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