"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    /**
     *
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        const conditions = new Array();
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        const conditions = new Array();
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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