"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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