"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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