"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class InstanceBase extends core_1.Resource {
    /**
     * Generate a unique instance Id that is safe to pass to CloudMap
     */
    uniqueInstanceId() {
        // Max length of 64 chars, get the last 64 chars
        const id = this.node.uniqueId;
        return id.substring(Math.max(id.length - 64, 0), id.length);
    }
}
exports.InstanceBase = InstanceBase;
//# sourceMappingURL=data:application/json;base64,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