"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using a domain name (CNAME).
 * @resource AWS::ServiceDiscovery::Instance
 */
class CnameInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        if (props.service.dnsRecordType !== service_1.DnsRecordType.CNAME) {
            throw new Error('A `CnameIntance` can only be used with a service using a `CNAME` record.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                AWS_INSTANCE_CNAME: props.instanceCname,
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.cname = props.instanceCname;
    }
}
exports.CnameInstance = CnameInstance;
//# sourceMappingURL=data:application/json;base64,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