"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * Secret Resource Policy
 */
class ResourcePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new iam.PolicyDocument();
        new secretsmanager_generated_1.CfnResourcePolicy(this, 'Resource', {
            resourcePolicy: this.document,
            secretId: props.secret.secretArn,
        });
    }
}
exports.ResourcePolicy = ResourcePolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDLENBQUMsbURBQW1EO0FBQ3pGLHFDQUFpRCxDQUFDLGdEQUFnRDtBQUVsRyx5RUFBK0Q7QUFVL0Q7O0dBRUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxlQUFRO0lBS3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUxyQjs7V0FFRztRQUNhLGFBQVEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLEVBQUUsQ0FBQztRQUdoRCxJQUFJLDRDQUFpQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDcEMsY0FBYyxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQzdCLFFBQVEsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLFNBQVM7U0FDbkMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBWkQsd0NBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSBcIi4uLy4uL2F3cy1pYW1cIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nXG5pbXBvcnQgeyBDb25zdHJ1Y3QsIFJlc291cmNlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBJU2VjcmV0IH0gZnJvbSAnLi9zZWNyZXQnO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2VQb2xpY3kgfSBmcm9tICcuL3NlY3JldHNtYW5hZ2VyLmdlbmVyYXRlZCc7XG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIFJlc291cmNlUG9saWN5XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUmVzb3VyY2VQb2xpY3lQcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIHNlY3JldCB0byBhdHRhY2ggYSByZXNvdXJjZS1iYXNlZCBwZXJtaXNzaW9ucyBwb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBzZWNyZXQ6IElTZWNyZXQ7XG59XG4vKipcbiAqIFNlY3JldCBSZXNvdXJjZSBQb2xpY3lcbiAqL1xuZXhwb3J0IGNsYXNzIFJlc291cmNlUG9saWN5IGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIC8qKlxuICAgICAqIFRoZSBJQU0gcG9saWN5IGRvY3VtZW50IGZvciB0aGlzIHBvbGljeS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgZG9jdW1lbnQgPSBuZXcgaWFtLlBvbGljeURvY3VtZW50KCk7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJlc291cmNlUG9saWN5UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgbmV3IENmblJlc291cmNlUG9saWN5KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIHJlc291cmNlUG9saWN5OiB0aGlzLmRvY3VtZW50LFxuICAgICAgICAgICAgc2VjcmV0SWQ6IHByb3BzLnNlY3JldC5zZWNyZXRBcm4sXG4gICAgICAgIH0pO1xuICAgIH1cbn1cbiJdfQ==