"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.CLOUDFRONT_ZONE_ID,
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmcm9udC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZyb250LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBOztHQUVHO0FBQ0gsTUFBYSxnQkFBZ0I7SUFNekIsWUFBNkIsWUFBa0Q7UUFBbEQsaUJBQVksR0FBWixZQUFZLENBQXNDO0lBQy9FLENBQUM7SUFDTSxJQUFJLENBQUMsT0FBMkI7UUFDbkMsT0FBTztZQUNILFlBQVksRUFBRSxnQkFBZ0IsQ0FBQyxrQkFBa0I7WUFDakQsT0FBTyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVTtTQUN4QyxDQUFDO0lBQ04sQ0FBQzs7QUFiTCw0Q0FjQztBQWJHOzs7R0FHRztBQUNvQixtQ0FBa0IsR0FBRyxnQkFBZ0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSBcIi4uLy4uL2F3cy1jbG91ZGZyb250XCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWRmcm9udCdcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSBcIi4uLy4uL2F3cy1yb3V0ZTUzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Mydcbi8qKlxuICogVXNlIGEgQ2xvdWRGcm9udCBEaXN0cmlidXRpb24gYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgQ2xvdWRGcm9udFRhcmdldCBpbXBsZW1lbnRzIHJvdXRlNTMuSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgICAvKipcbiAgICAgKiBUaGUgaG9zdGVkIHpvbmUgSWQgaWYgdXNpbmcgYW4gYWxpYXMgcmVjb3JkIGluIFJvdXRlNTMuXG4gICAgICogVGhpcyB2YWx1ZSBuZXZlciBjaGFuZ2VzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURGUk9OVF9aT05FX0lEID0gJ1oyRkRUTkRBVEFRWVcyJztcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRpc3RyaWJ1dGlvbjogY2xvdWRmcm9udC5DbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uKSB7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LkNMT1VERlJPTlRfWk9ORV9JRCxcbiAgICAgICAgICAgIGRuc05hbWU6IHRoaXMuZGlzdHJpYnV0aW9uLmRvbWFpbk5hbWUsXG4gICAgICAgIH07XG4gICAgfVxufVxuIl19