"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
    }
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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