"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Connection endpoint of a redshift cluster
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = core_1.Token.isUnresolved(port) ? core_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
exports.Endpoint = Endpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFtQyxDQUFDLGdEQUFnRDtBQUNwRjs7OztHQUlHO0FBQ0gsTUFBYSxRQUFRO0lBYWpCLFlBQVksT0FBZSxFQUFFLElBQVk7UUFDckMsSUFBSSxDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUM7UUFDeEIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7UUFDakIsTUFBTSxRQUFRLEdBQUcsWUFBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsWUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ3hFLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxPQUFPLElBQUksUUFBUSxFQUFFLENBQUM7SUFDbEQsQ0FBQztDQUNKO0FBbkJELDRCQW1CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIENvbm5lY3Rpb24gZW5kcG9pbnQgb2YgYSByZWRzaGlmdCBjbHVzdGVyXG4gKlxuICogQ29uc2lzdHMgb2YgYSBjb21iaW5hdGlvbiBvZiBob3N0bmFtZSBhbmQgcG9ydC5cbiAqL1xuZXhwb3J0IGNsYXNzIEVuZHBvaW50IHtcbiAgICAvKipcbiAgICAgKiBUaGUgaG9zdG5hbWUgb2YgdGhlIGVuZHBvaW50XG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGhvc3RuYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIHBvcnQgb2YgdGhlIGVuZHBvaW50XG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcbiAgICAvKipcbiAgICAgKiBUaGUgY29tYmluYXRpb24gb2YgXCJIT1NUTkFNRTpQT1JUXCIgZm9yIHRoaXMgZW5kcG9pbnRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgc29ja2V0QWRkcmVzczogc3RyaW5nO1xuICAgIGNvbnN0cnVjdG9yKGFkZHJlc3M6IHN0cmluZywgcG9ydDogbnVtYmVyKSB7XG4gICAgICAgIHRoaXMuaG9zdG5hbWUgPSBhZGRyZXNzO1xuICAgICAgICB0aGlzLnBvcnQgPSBwb3J0O1xuICAgICAgICBjb25zdCBwb3J0RGVzYyA9IFRva2VuLmlzVW5yZXNvbHZlZChwb3J0KSA/IFRva2VuLmFzU3RyaW5nKHBvcnQpIDogcG9ydDtcbiAgICAgICAgdGhpcy5zb2NrZXRBZGRyZXNzID0gYCR7YWRkcmVzc306JHtwb3J0RGVzY31gO1xuICAgIH1cbn1cbiJdfQ==