"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const secretsmanager = require("../../aws-secretsmanager"); // Automatically re-written from '@aws-cdk/aws-secretsmanager'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_a = props.masterSecret) === null || _a === void 0 ? void 0 : _a.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: '"@/\\',
            },
        });
    }
}
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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