"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString,
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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