"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics
 */
class MetricFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: props.metricValue !== undefined ? props.metricValue : '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
}
exports.MetricFilter = MetricFilter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0cmljLWZpbHRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1ldHJpYy1maWx0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBaUQsQ0FBQyxnREFBZ0Q7QUFFbEcscURBQW1EO0FBVW5EOztHQUVHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsZUFBUTtJQUN0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsc0VBQXNFO1FBQ3RFLGlEQUFpRDtRQUNqRCxFQUFFO1FBQ0Ysa0VBQWtFO1FBQ2xFLCtEQUErRDtRQUMvRCwrREFBK0Q7UUFDL0QsRUFBRTtRQUNGLHFHQUFxRztRQUNyRyxJQUFJLGdDQUFlLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxZQUFZO1lBQ3pDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLGdCQUFnQjtZQUNuRCxxQkFBcUIsRUFBRSxDQUFDO29CQUNoQixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7b0JBQ3RDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtvQkFDNUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxHQUFHO29CQUN0RSxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7aUJBQ25DLENBQUM7U0FDVCxDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUF0QkQsb0NBc0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBSZXNvdXJjZSB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgSUxvZ0dyb3VwLCBNZXRyaWNGaWx0ZXJPcHRpb25zIH0gZnJvbSAnLi9sb2ctZ3JvdXAnO1xuaW1wb3J0IHsgQ2ZuTWV0cmljRmlsdGVyIH0gZnJvbSAnLi9sb2dzLmdlbmVyYXRlZCc7XG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgTWV0cmljRmlsdGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTWV0cmljRmlsdGVyUHJvcHMgZXh0ZW5kcyBNZXRyaWNGaWx0ZXJPcHRpb25zIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbG9nIGdyb3VwIHRvIGNyZWF0ZSB0aGUgZmlsdGVyIG9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxvZ0dyb3VwOiBJTG9nR3JvdXA7XG59XG4vKipcbiAqIEEgZmlsdGVyIHRoYXQgZXh0cmFjdHMgaW5mb3JtYXRpb24gZnJvbSBDbG91ZFdhdGNoIExvZ3MgYW5kIGVtaXRzIHRvIENsb3VkV2F0Y2ggTWV0cmljc1xuICovXG5leHBvcnQgY2xhc3MgTWV0cmljRmlsdGVyIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBNZXRyaWNGaWx0ZXJQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICAvLyBJdCBsb29rcyBvZGQgdG8gbWFwIHRoaXMgb2JqZWN0IHRvIGEgc2luZ2xldG9uIGxpc3QsIGJ1dCB0aGF0J3MgaG93XG4gICAgICAgIC8vIHdlJ3JlIHN1cHBvc2VkIHRvIGRvIGl0IGFjY29yZGluZyB0byB0aGUgZG9jcy5cbiAgICAgICAgLy9cbiAgICAgICAgLy8gPiBDdXJyZW50bHksIHlvdSBjYW4gc3BlY2lmeSBvbmx5IG9uZSBtZXRyaWMgdHJhbnNmb3JtYXRpb24gZm9yXG4gICAgICAgIC8vID4gZWFjaCBtZXRyaWMgZmlsdGVyLiBJZiB5b3Ugd2FudCB0byBzcGVjaWZ5IG11bHRpcGxlIG1ldHJpY1xuICAgICAgICAvLyA+IHRyYW5zZm9ybWF0aW9ucywgeW91IG11c3Qgc3BlY2lmeSBtdWx0aXBsZSBtZXRyaWMgZmlsdGVycy5cbiAgICAgICAgLy9cbiAgICAgICAgLy8gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWxvZ3MtbWV0cmljZmlsdGVyLmh0bWxcbiAgICAgICAgbmV3IENmbk1ldHJpY0ZpbHRlcih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBsb2dHcm91cE5hbWU6IHByb3BzLmxvZ0dyb3VwLmxvZ0dyb3VwTmFtZSxcbiAgICAgICAgICAgIGZpbHRlclBhdHRlcm46IHByb3BzLmZpbHRlclBhdHRlcm4ubG9nUGF0dGVyblN0cmluZyxcbiAgICAgICAgICAgIG1ldHJpY1RyYW5zZm9ybWF0aW9uczogW3tcbiAgICAgICAgICAgICAgICAgICAgbWV0cmljTmFtZXNwYWNlOiBwcm9wcy5tZXRyaWNOYW1lc3BhY2UsXG4gICAgICAgICAgICAgICAgICAgIG1ldHJpY05hbWU6IHByb3BzLm1ldHJpY05hbWUsXG4gICAgICAgICAgICAgICAgICAgIG1ldHJpY1ZhbHVlOiBwcm9wcy5tZXRyaWNWYWx1ZSAhPT0gdW5kZWZpbmVkID8gcHJvcHMubWV0cmljVmFsdWUgOiAnMScsXG4gICAgICAgICAgICAgICAgICAgIGRlZmF1bHRWYWx1ZTogcHJvcHMuZGVmYXVsdFZhbHVlLFxuICAgICAgICAgICAgICAgIH1dLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=