"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Use a Lamda Function as the destination for a log subscription
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal('logs.amazonaws.com'),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope,
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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