"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs)
 *
 * @deprecated Use {@link NODEJS_10_X}
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3)
 *
 * @deprecated Use {@link NODEJS_10_X}
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10)
 *
 * @deprecated Use {@link NODEJS_10_X}
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10)
 *
 * @deprecated Use {@link NODEJS_10_X}
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x)
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x)
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The Python 2.7 runtime (python2.7)
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6)
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.7 runtime (python3.7)
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.8 runtime (python3.8)
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON);
/**
 * The Java 8 runtime (java8)
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA);
/**
 * The Java 11 runtime (java11)
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA);
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0)
 *
 * @deprecated Use {@link DOTNET_CORE_2_1}
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0)
 *
 * @deprecated Use {@link DOTNET_CORE_2_1}
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1)
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1)
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE);
/**
 * The Go 1.x runtime (go1.x)
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
/**
 * The Ruby 2.5 runtime (ruby2.5)
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7)
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
//# sourceMappingURL=data:application/json;base64,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