"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Configure options for asynchronous invocation on a version or an alias
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 */
class EventInvokeConfig extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: props.retryAttempts !== undefined ? props.retryAttempts : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
//# sourceMappingURL=data:application/json;base64,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