"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Finds the closest path containg a path
 */
function findClosestPathContaining(p) {
    for (const nodeModulesPath of module.paths) {
        if (fs.existsSync(path.join(path.dirname(nodeModulesPath), p))) {
            return path.dirname(nodeModulesPath);
        }
    }
    return undefined;
}
/**
 * Finds closest package.json path
 */
function findPkgPath() {
    return findClosestPathContaining('package.json');
}
exports.findPkgPath = findPkgPath;
/**
 * Finds closest .git/
 */
function findGitPath() {
    return findClosestPathContaining(`.git${path.sep}`);
}
exports.findGitPath = findGitPath;
//# sourceMappingURL=data:application/json;base64,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