"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
    }
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
//# sourceMappingURL=data:application/json;base64,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