"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * An SQS dead letter queue destination configuration for a Lambda event source
 */
class SqsDlq {
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDlq = SqsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFFQTs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNmLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDOUMsQ0FBQztJQUNEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE9BQTRCLEVBQUUsYUFBd0I7UUFDOUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUM1QyxPQUFPO1lBQ0gsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtTQUNuQyxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBWkQsd0JBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEbHFEZXN0aW5hdGlvbkNvbmZpZywgSUV2ZW50U291cmNlRGxxLCBJRXZlbnRTb3VyY2VNYXBwaW5nLCBJRnVuY3Rpb24gfSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCAqIGFzIHNxcyBmcm9tIFwiLi4vLi4vYXdzLXNxc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNxcydcbi8qKlxuICogQW4gU1FTIGRlYWQgbGV0dGVyIHF1ZXVlIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIGEgTGFtYmRhIGV2ZW50IHNvdXJjZVxuICovXG5leHBvcnQgY2xhc3MgU3FzRGxxIGltcGxlbWVudHMgSUV2ZW50U291cmNlRGxxIHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFJldHVybnMgYSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciB0aGUgRExRXG4gICAgICovXG4gICAgcHVibGljIGJpbmQoX3RhcmdldDogSUV2ZW50U291cmNlTWFwcGluZywgdGFyZ2V0SGFuZGxlcjogSUZ1bmN0aW9uKTogRGxxRGVzdGluYXRpb25Db25maWcge1xuICAgICAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKHRhcmdldEhhbmRsZXIpO1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZGVzdGluYXRpb246IHRoaXMucXVldWUucXVldWVBcm4sXG4gICAgICAgIH07XG4gICAgfVxufVxuIl19