"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic) {
        this.topic = topic;
    }
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target));
    }
}
exports.SnsEventSource = SnsEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUEsb0RBQW9ELENBQUMsaUVBQWlFO0FBQ3RIOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBQ3ZCLFlBQXFCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDdEMsQ0FBQztJQUNNLElBQUksQ0FBQyxNQUF3QjtRQUNoQyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7Q0FDSjtBQU5ELHdDQU1DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gXCIuLi8uLi9hd3MtbGFtYmRhXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuaW1wb3J0ICogYXMgc3VicyBmcm9tIFwiLi4vLi4vYXdzLXNucy1zdWJzY3JpcHRpb25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zLXN1YnNjcmlwdGlvbnMnXG4vKipcbiAqIFVzZSBhbiBBbWF6b24gU05TIHRvcGljIGFzIGFuIGV2ZW50IHNvdXJjZSBmb3IgQVdTIExhbWJkYS5cbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0V2ZW50U291cmNlIGltcGxlbWVudHMgbGFtYmRhLklFdmVudFNvdXJjZSB7XG4gICAgY29uc3RydWN0b3IocmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMpIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQodGFyZ2V0OiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gICAgICAgIHRoaXMudG9waWMuYWRkU3Vic2NyaXB0aW9uKG5ldyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvbih0YXJnZXQpKTtcbiAgICB9XG59XG4iXX0=