"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFFQTs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNmLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDOUMsQ0FBQztJQUNEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE9BQTRCLEVBQUUsYUFBd0I7UUFDOUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDdkMsT0FBTztZQUNILFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDbkMsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVpELHdCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGxxRGVzdGluYXRpb25Db25maWcsIElFdmVudFNvdXJjZURscSwgSUV2ZW50U291cmNlTWFwcGluZywgSUZ1bmN0aW9uIH0gZnJvbSBcIi4uLy4uL2F3cy1sYW1iZGFcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnXG5pbXBvcnQgKiBhcyBzbnMgZnJvbSBcIi4uLy4uL2F3cy1zbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnXG4vKipcbiAqIEFuIFNOUyBkZWFkIGxldHRlciBxdWV1ZSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBldmVudCBzb3VyY2VcbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0RscSBpbXBsZW1lbnRzIElFdmVudFNvdXJjZURscSB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgdGhlIERMUVxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICAgICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2godGFyZ2V0SGFuZGxlcik7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBkZXN0aW5hdGlvbjogdGhpcy50b3BpYy50b3BpY0FybixcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=