"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apigw = require("../../aws-apigateway"); // Automatically re-written from '@aws-cdk/aws-apigateway'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = `${target.node.uniqueId}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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