import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::IoTEvents::DetectorModel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export interface CfnDetectorModelProps {
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     */
    readonly detectorModelDefinition?: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     */
    readonly detectorModelDescription?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     */
    readonly detectorModelName?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     */
    readonly evaluationMethod?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     */
    readonly key?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`
 *
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare class CfnDetectorModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::DetectorModel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDetectorModel;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     */
    detectorModelDefinition: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     */
    detectorModelDescription: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     */
    detectorModelName: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     */
    evaluationMethod: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     */
    key: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::DetectorModel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDetectorModelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html
     */
    interface ActionProperty {
        /**
         * `CfnDetectorModel.ActionProperty.ClearTimer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-cleartimer
         */
        readonly clearTimer?: CfnDetectorModel.ClearTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDB`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodb
         */
        readonly dynamoDb?: CfnDetectorModel.DynamoDBProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDBv2`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodbv2
         */
        readonly dynamoDBv2?: CfnDetectorModel.DynamoDBv2Property | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Firehose`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-firehose
         */
        readonly firehose?: CfnDetectorModel.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotevents
         */
        readonly iotEvents?: CfnDetectorModel.IotEventsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotSiteWise`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotsitewise
         */
        readonly iotSiteWise?: CfnDetectorModel.IotSiteWiseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotTopicPublish`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iottopicpublish
         */
        readonly iotTopicPublish?: CfnDetectorModel.IotTopicPublishProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Lambda`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-lambda
         */
        readonly lambda?: CfnDetectorModel.LambdaProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.ResetTimer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-resettimer
         */
        readonly resetTimer?: CfnDetectorModel.ResetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetTimer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-settimer
         */
        readonly setTimer?: CfnDetectorModel.SetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetVariable`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-setvariable
         */
        readonly setVariable?: CfnDetectorModel.SetVariableProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sns
         */
        readonly sns?: CfnDetectorModel.SnsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sqs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sqs
         */
        readonly sqs?: CfnDetectorModel.SqsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html
     */
    interface AssetPropertyTimestampProperty {
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.OffsetInNanos`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-offsetinnanos
         */
        readonly offsetInNanos?: string;
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.TimeInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-timeinseconds
         */
        readonly timeInSeconds?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html
     */
    interface AssetPropertyValueProperty {
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Quality`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-quality
         */
        readonly quality?: string;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Timestamp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-timestamp
         */
        readonly timestamp?: CfnDetectorModel.AssetPropertyTimestampProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-value
         */
        readonly value?: CfnDetectorModel.AssetPropertyVariantProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html
     */
    interface AssetPropertyVariantProperty {
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.BooleanValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-booleanvalue
         */
        readonly booleanValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.DoubleValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-doublevalue
         */
        readonly doubleValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.IntegerValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-integervalue
         */
        readonly integerValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.StringValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-stringvalue
         */
        readonly stringValue?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html
     */
    interface ClearTimerProperty {
        /**
         * `CfnDetectorModel.ClearTimerProperty.TimerName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html#cfn-iotevents-detectormodel-cleartimer-timername
         */
        readonly timerName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html
     */
    interface DetectorModelDefinitionProperty {
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.InitialStateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-initialstatename
         */
        readonly initialStateName?: string;
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.States`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-states
         */
        readonly states?: Array<CfnDetectorModel.StateProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html
     */
    interface DynamoDBProperty {
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyfield
         */
        readonly hashKeyField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeytype
         */
        readonly hashKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyvalue
         */
        readonly hashKeyValue?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Operation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-operation
         */
        readonly operation?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBProperty.PayloadField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payloadfield
         */
        readonly payloadField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyfield
         */
        readonly rangeKeyField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeytype
         */
        readonly rangeKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyvalue
         */
        readonly rangeKeyValue?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.TableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-tablename
         */
        readonly tableName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html
     */
    interface DynamoDBv2Property {
        /**
         * `CfnDetectorModel.DynamoDBv2Property.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBv2Property.TableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-tablename
         */
        readonly tableName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html
     */
    interface EventProperty {
        /**
         * `CfnDetectorModel.EventProperty.Actions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-actions
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.EventProperty.Condition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-condition
         */
        readonly condition?: string;
        /**
         * `CfnDetectorModel.EventProperty.EventName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-eventname
         */
        readonly eventName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html
     */
    interface FirehoseProperty {
        /**
         * `CfnDetectorModel.FirehoseProperty.DeliveryStreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-deliverystreamname
         */
        readonly deliveryStreamName?: string;
        /**
         * `CfnDetectorModel.FirehoseProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.FirehoseProperty.Separator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-separator
         */
        readonly separator?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html
     */
    interface IotEventsProperty {
        /**
         * `CfnDetectorModel.IotEventsProperty.InputName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-inputname
         */
        readonly inputName?: string;
        /**
         * `CfnDetectorModel.IotEventsProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html
     */
    interface IotSiteWiseProperty {
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.AssetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-assetid
         */
        readonly assetId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.EntryId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-entryid
         */
        readonly entryId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyAlias`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyalias
         */
        readonly propertyAlias?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyid
         */
        readonly propertyId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyvalue
         */
        readonly propertyValue?: CfnDetectorModel.AssetPropertyValueProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html
     */
    interface IotTopicPublishProperty {
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.MqttTopic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-mqtttopic
         */
        readonly mqttTopic?: string;
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html
     */
    interface LambdaProperty {
        /**
         * `CfnDetectorModel.LambdaProperty.FunctionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-functionarn
         */
        readonly functionArn?: string;
        /**
         * `CfnDetectorModel.LambdaProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html
     */
    interface OnEnterProperty {
        /**
         * `CfnDetectorModel.OnEnterProperty.Events`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html#cfn-iotevents-detectormodel-onenter-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html
     */
    interface OnExitProperty {
        /**
         * `CfnDetectorModel.OnExitProperty.Events`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html#cfn-iotevents-detectormodel-onexit-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html
     */
    interface OnInputProperty {
        /**
         * `CfnDetectorModel.OnInputProperty.Events`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.OnInputProperty.TransitionEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-transitionevents
         */
        readonly transitionEvents?: Array<CfnDetectorModel.TransitionEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html
     */
    interface PayloadProperty {
        /**
         * `CfnDetectorModel.PayloadProperty.ContentExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-contentexpression
         */
        readonly contentExpression?: string;
        /**
         * `CfnDetectorModel.PayloadProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html
     */
    interface ResetTimerProperty {
        /**
         * `CfnDetectorModel.ResetTimerProperty.TimerName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html#cfn-iotevents-detectormodel-resettimer-timername
         */
        readonly timerName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html
     */
    interface SetTimerProperty {
        /**
         * `CfnDetectorModel.SetTimerProperty.DurationExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-durationexpression
         */
        readonly durationExpression?: string;
        /**
         * `CfnDetectorModel.SetTimerProperty.Seconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-seconds
         */
        readonly seconds?: number;
        /**
         * `CfnDetectorModel.SetTimerProperty.TimerName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-timername
         */
        readonly timerName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html
     */
    interface SetVariableProperty {
        /**
         * `CfnDetectorModel.SetVariableProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-value
         */
        readonly value?: string;
        /**
         * `CfnDetectorModel.SetVariableProperty.VariableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-variablename
         */
        readonly variableName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html
     */
    interface SnsProperty {
        /**
         * `CfnDetectorModel.SnsProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SnsProperty.TargetArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-targetarn
         */
        readonly targetArn?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html
     */
    interface SqsProperty {
        /**
         * `CfnDetectorModel.SqsProperty.Payload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SqsProperty.QueueUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-queueurl
         */
        readonly queueUrl?: string;
        /**
         * `CfnDetectorModel.SqsProperty.UseBase64`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-usebase64
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html
     */
    interface StateProperty {
        /**
         * `CfnDetectorModel.StateProperty.OnEnter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onenter
         */
        readonly onEnter?: CfnDetectorModel.OnEnterProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnExit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onexit
         */
        readonly onExit?: CfnDetectorModel.OnExitProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnInput`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-oninput
         */
        readonly onInput?: CfnDetectorModel.OnInputProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.StateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-statename
         */
        readonly stateName?: string;
    }
}
export declare namespace CfnDetectorModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html
     */
    interface TransitionEventProperty {
        /**
         * `CfnDetectorModel.TransitionEventProperty.Actions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-actions
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.TransitionEventProperty.Condition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-condition
         */
        readonly condition?: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.EventName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-eventname
         */
        readonly eventName?: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.NextState`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-nextstate
         */
        readonly nextState?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTEvents::Input`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export interface CfnInputProps {
    /**
     * `AWS::IoTEvents::Input.InputDefinition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     */
    readonly inputDefinition?: CfnInput.InputDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::Input.InputDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     */
    readonly inputDescription?: string;
    /**
     * `AWS::IoTEvents::Input.InputName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     */
    readonly inputName?: string;
    /**
     * `AWS::IoTEvents::Input.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`
 *
 * @cloudformationResource AWS::IoTEvents::Input
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::Input";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnInput;
    /**
     * `AWS::IoTEvents::Input.InputDefinition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     */
    inputDefinition: CfnInput.InputDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTEvents::Input.InputDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     */
    inputDescription: string | undefined;
    /**
     * `AWS::IoTEvents::Input.InputName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     */
    inputName: string | undefined;
    /**
     * `AWS::IoTEvents::Input.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::Input`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html
     */
    interface AttributeProperty {
        /**
         * `CfnInput.AttributeProperty.JsonPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html#cfn-iotevents-input-attribute-jsonpath
         */
        readonly jsonPath?: string;
    }
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html
     */
    interface InputDefinitionProperty {
        /**
         * `CfnInput.InputDefinitionProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html#cfn-iotevents-input-inputdefinition-attributes
         */
        readonly attributes?: Array<CfnInput.AttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
