"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* istanbul ignore file */
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const tls = require("tls");
const url = require("url");
let client;
function iam() {
    if (!client) {
        client = new aws.IAM();
    }
    return client;
}
function defaultLogger(fmt, ...args) {
    // tslint:disable-next-line: no-console
    console.log(fmt, ...args);
}
/**
 * Downloads the CA thumbprint from the issuer URL
 */
async function downloadThumbprint(issuerUrl) {
    exports.external.log(`downloading certificate authority thumbprint for ${issuerUrl}`);
    return new Promise((ok, ko) => {
        const purl = url.parse(issuerUrl);
        const port = purl.port ? parseInt(purl.port, 10) : 443;
        if (!purl.host) {
            return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));
        }
        const socket = tls.connect(port, purl.host, { rejectUnauthorized: false });
        socket.once('error', ko);
        socket.once('secureConnect', () => {
            const cert = socket.getPeerCertificate();
            socket.end();
            const thumbprint = cert.fingerprint.split(':').join('');
            exports.external.log(`certificate authority thumbprint for ${issuerUrl} is ${thumbprint}`);
            ok(thumbprint);
        });
    });
}
// allows unit test to replace with mocks
// tslint:disable:max-line-length
exports.external = {
    downloadThumbprint,
    log: defaultLogger,
    createOpenIDConnectProvider: (req) => iam().createOpenIDConnectProvider(req).promise(),
    deleteOpenIDConnectProvider: (req) => iam().deleteOpenIDConnectProvider(req).promise(),
    updateOpenIDConnectProviderThumbprint: (req) => iam().updateOpenIDConnectProviderThumbprint(req).promise(),
    addClientIDToOpenIDConnectProvider: (req) => iam().addClientIDToOpenIDConnectProvider(req).promise(),
    removeClientIDFromOpenIDConnectProvider: (req) => iam().removeClientIDFromOpenIDConnectProvider(req).promise(),
};
//# sourceMappingURL=data:application/json;base64,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