"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Enum for representing all the days of the week
 */
var Weekday;
(function (Weekday) {
    /**
     * Sunday
     */
    Weekday["SUNDAY"] = "0";
    /**
     * Monday
     */
    Weekday["MONDAY"] = "1";
    /**
     * Tuesday
     */
    Weekday["TUESDAY"] = "2";
    /**
     * Wednesday
     */
    Weekday["WEDNESDAY"] = "3";
    /**
     * Thursday
     */
    Weekday["THURSDAY"] = "4";
    /**
     * Friday
     */
    Weekday["FRIDAY"] = "5";
    /**
     * Saturday
     */
    Weekday["SATURDAY"] = "6";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 */
class LustreMaintenanceTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
//# sourceMappingURL=data:application/json;base64,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