"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat the values
            if (Array.isArray(srcValue)) {
                destObj[field] = destValue.concat(srcValue);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,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