import * as events from "../../aws-events";
import * as sfn from "../../aws-stepfunctions";
/**
 * Customize the Step Functions State Machine target
 */
export interface SfnStateMachineProps {
    /**
     * The input to the state machine execution
     *
     * @default the entire CloudWatch event
     */
    readonly input?: events.RuleTargetInput;
}
/**
 * Use a StepFunctions state machine as a target for AWS CloudWatch event rules.
 */
export declare class SfnStateMachine implements events.IRuleTarget {
    readonly machine: sfn.IStateMachine;
    private readonly props;
    constructor(machine: sfn.IStateMachine, props?: SfnStateMachineProps);
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
