import * as events from "../../aws-events";
import * as sns from "../../aws-sns";
/**
 * Customize the SNS Topic Event Target
 */
export interface SnsTopicProps {
    /**
     * The message to send to the topic
     *
     * @default the entire CloudWatch event
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * Use an SNS topic as a target for AWS CloudWatch event rules.
 *
 * @example
 *
 *    // publish to an SNS topic every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.SnsTopic(topic));
 *
 */
export declare class SnsTopic implements events.IRuleTarget {
    readonly topic: sns.ITopic;
    private readonly props;
    constructor(topic: sns.ITopic, props?: SnsTopicProps);
    /**
     * Returns a RuleTarget that can be used to trigger this SNS topic as a
     * result from a CloudWatch event.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
