"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @example
 *
 *    // put to a Kinesis stream every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.KinesisStream(stream));
 *
 */
class KinesisStream {
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Kinesis Stream as a
     * result from a CloudWatch event.
     */
    bind(_rule, _id) {
        const policyStatements = [new iam.PolicyStatement({
                actions: ['kinesis:PutRecord', 'kinesis:PutRecords'],
                resources: [this.stream.streamArn],
            })];
        return {
            id: '',
            arn: this.stream.streamArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
            kinesisParameters: this.props.partitionKeyPath ? { partitionKeyPath: this.props.partitionKeyPath } : undefined,
        };
    }
}
exports.KinesisStream = KinesisStream;
//# sourceMappingURL=data:application/json;base64,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