"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Start a CodeBuild build when an AWS CloudWatch events rule is triggered.
 */
class CodeBuildProject {
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
    }
    /**
     * Allows using build projects as event rule targets.
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.project.projectArn,
            role: util_1.singletonEventRole(this.project, [
                new iam.PolicyStatement({
                    actions: ['codebuild:StartBuild'],
                    resources: [this.project.projectArn],
                }),
            ]),
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
exports.CodeBuildProject = CodeBuildProject;
//# sourceMappingURL=data:application/json;base64,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