"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * @experimental
 */
class BatchJob {
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from a CloudWatch event.
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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