"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const path = require("path");
const sdk_api_metadata_generated_1 = require("./sdk-api-metadata.generated");
const util_1 = require("./util");
const awsSdkMetadata = sdk_api_metadata_generated_1.metadata;
/**
 * Use an AWS Lambda function that makes API calls as an event rule target.
 */
class AwsApi {
    constructor(props) {
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this AwsApi as a
     * result from a CloudWatch event.
     */
    bind(rule, id) {
        const handler = new lambda.SingletonFunction(rule, `${rule.node.id}${id}Handler`, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'aws-api-handler')),
            runtime: lambda.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            uuid: 'b4cf1abd-4e4f-4bc6-9944-1af7ccd9ec37',
            lambdaPurpose: 'AWS',
        });
        if (this.props.policyStatement) {
            handler.addToRolePolicy(this.props.policyStatement);
        }
        else {
            handler.addToRolePolicy(new iam.PolicyStatement({
                actions: [awsSdkToIamAction(this.props.service, this.props.action)],
                resources: ['*'],
            }));
        }
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, handler);
        const input = {
            service: this.props.service,
            action: this.props.action,
            parameters: this.props.parameters,
            catchErrorPattern: this.props.catchErrorPattern,
            apiVersion: this.props.apiVersion,
        };
        return {
            id: '',
            arn: handler.functionArn,
            input: events.RuleTargetInput.fromObject(input),
            targetResource: handler,
        };
    }
}
exports.AwsApi = AwsApi;
/**
 * Transform SDK service/action to IAM action using metadata from aws-sdk module.
 */
function awsSdkToIamAction(service, action) {
    const srv = service.toLowerCase();
    const iamService = awsSdkMetadata[srv].prefix || srv;
    const iamAction = action.charAt(0).toUpperCase() + action.slice(1);
    return `${iamService}:${iamAction}`;
}
//# sourceMappingURL=data:application/json;base64,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