"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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