"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * An EC2 instance that is the target for load balancing
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 */
class InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instanceId Instance ID of the instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
class InstanceTarget extends InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instance Instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
//# sourceMappingURL=data:application/json;base64,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