"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._getKubectlCreationRoleArn(provider.role),
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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