import * as iam from "../../aws-iam";
import { ArnComponents, Construct } from "../../core";
import { CfnClusterProps } from './eks.generated';
/**
 * A low-level CFN resource Amazon EKS cluster implemented through a custom
 * resource.
 *
 * Implements EKS create/update/delete through a CloudFormation custom resource
 * in order to allow us to control the IAM role which creates the cluster. This
 * is required in order to be able to allow CloudFormation to interact with the
 * cluster via `kubectl` to enable Kubernetes management capabilities like apply
 * manifest and IAM role/user RBAC mapping.
 */
export declare class ClusterResource extends Construct {
    readonly attrEndpoint: string;
    readonly attrArn: string;
    readonly attrCertificateAuthorityData: string;
    readonly attrOpenIdConnectIssuerUrl: string;
    readonly attrOpenIdConnectIssuer: string;
    readonly ref: string;
    /**
     * The IAM role which created the cluster. Initially this is the only IAM role
     * that gets administrator privilages on the cluster (`system:masters`), and
     * will be able to issue `kubectl` commands against it.
     */
    private readonly creationRole;
    private readonly trustedPrincipals;
    constructor(scope: Construct, id: string, props: CfnClusterProps);
    /**
     * Returns the ARN of the cluster creation role and grants `trustedRole`
     * permissions to assume this role.
     */
    getCreationRoleArn(trustedRole?: iam.IRole): string;
}
export declare function clusterArnComponents(clusterName: string): ArnComponents;
