"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const spot_interrupt_handler_1 = require("./spot-interrupt-handler");
function renderUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? spot_interrupt_handler_1.LifecycleLabel.SPOT : spot_interrupt_handler_1.LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderUserData = renderUserData;
//# sourceMappingURL=data:application/json;base64,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