"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var LifecycleLabel;
(function (LifecycleLabel) {
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
const DEFAULT_NODE_SELECTOR = { lifecycle: LifecycleLabel.SPOT };
function spotInterruptHandler(nodeSelector = DEFAULT_NODE_SELECTOR) {
    return [
        {
            kind: 'ClusterRole',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            rules: [
                {
                    apiGroups: [
                        'apps',
                    ],
                    resources: [
                        'daemonsets',
                    ],
                    verbs: [
                        'get',
                        'delete',
                    ],
                },
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        '*',
                    ],
                    verbs: [
                        '*',
                    ],
                },
                {
                    apiGroups: [
                        'rbac.authorization.k8s.io',
                    ],
                    resources: [
                        '*',
                    ],
                    verbs: [
                        '*',
                    ],
                },
                {
                    apiGroups: [
                        'apiextensions.k8s.io',
                    ],
                    resources: [
                        'customresourcedefinitions',
                    ],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                        'create',
                        'delete',
                    ],
                },
            ],
        },
        {
            apiVersion: 'v1',
            kind: 'ServiceAccount',
            metadata: {
                name: 'node-termination-handler',
            },
        },
        {
            kind: 'ClusterRoleBinding',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: 'node-termination-handler',
                    namespace: 'default',
                },
            ],
            roleRef: {
                kind: 'ClusterRole',
                name: 'node-termination-handler',
                apiGroup: 'rbac.authorization.k8s.io',
            },
        },
        {
            apiVersion: 'apps/v1beta2',
            kind: 'DaemonSet',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            spec: {
                selector: {
                    matchLabels: {
                        app: 'node-termination-handler',
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: 'node-termination-handler',
                        },
                    },
                    spec: {
                        serviceAccountName: 'node-termination-handler',
                        containers: [
                            {
                                name: 'node-termination-handler',
                                image: 'amazon/aws-node-termination-handler:v1.0.0',
                                imagePullPolicy: 'Always',
                                env: [
                                    {
                                        name: 'NODE_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'spec.nodeName',
                                            },
                                        },
                                    },
                                    {
                                        name: 'POD_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.name',
                                            },
                                        },
                                    },
                                    {
                                        name: 'NAMESPACE',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.namespace',
                                            },
                                        },
                                    },
                                    {
                                        name: 'SPOT_POD_IP',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'status.podIP',
                                            },
                                        },
                                    },
                                ],
                                resources: {
                                    requests: {
                                        memory: '64Mi',
                                        cpu: '50m',
                                    },
                                    limits: {
                                        memory: '128Mi',
                                        cpu: '100m',
                                    },
                                },
                            },
                        ],
                        nodeSelector,
                    },
                },
            },
        },
    ];
}
exports.spotInterruptHandler = spotInterruptHandler;
//# sourceMappingURL=data:application/json;base64,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