"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Remove undefined values from a dictionary
 */
function removeEmpty(x) {
    for (const key of Object.keys(x)) {
        if (x[key] === undefined) {
            delete x[key];
        }
    }
    return x;
}
exports.removeEmpty = removeEmpty;
/**
 * Checks that a value is a positive integer
 */
function ensurePositiveInteger(val) {
    if (!core_1.Token.isUnresolved(val) && Number.isInteger(val) && val < 0) {
        throw new Error(`\`${val}\` must be a positive integer.`);
    }
}
exports.ensurePositiveInteger = ensurePositiveInteger;
/**
 * Checks that a value is contained in a range of two other values
 */
function ensureInRange(val, start, end) {
    if (!core_1.Token.isUnresolved(val) && !(val >= start && val <= end)) {
        throw new Error(`\`${val}\` must be within range ${start}:${end}`);
    }
}
exports.ensureInRange = ensureInRange;
function stringifyOptions(options) {
    const _options = {};
    const filteredOptions = removeEmpty(options);
    for (const key of Object.keys(filteredOptions)) {
        // Convert value to string
        _options[key] = `${filteredOptions[key]}`;
    }
    return _options;
}
exports.stringifyOptions = stringifyOptions;
function renderCommonLogDriverOptions(opts) {
    return {
        'tag': opts.tag,
        'labels': joinWithCommas(opts.labels),
        'env': joinWithCommas(opts.env),
        'env-regex': opts.envRegex,
    };
}
exports.renderCommonLogDriverOptions = renderCommonLogDriverOptions;
function joinWithCommas(xs) {
    return xs && xs.join(',');
}
exports.joinWithCommas = joinWithCommas;
//# sourceMappingURL=data:application/json;base64,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