"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmx1ZW50ZC1sb2ctZHJpdmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZmx1ZW50ZC1sb2ctZHJpdmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBR0EsNkNBQTBEO0FBQzFELG1DQUF5RTtBQStDekU7O0dBRUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLHNCQUFTO0lBQzNDOzs7O09BSUc7SUFDSCxZQUE2QixRQUErQixFQUFFO1FBQzFELEtBQUssRUFBRSxDQUFDO1FBRGlCLFVBQUssR0FBTCxLQUFLLENBQTRCO0lBRTlELENBQUM7SUFDRDs7T0FFRztJQUNJLElBQUksQ0FBQyxNQUFpQixFQUFFLG9CQUF5QztRQUNwRSxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsT0FBTyxFQUFFLHdCQUFnQixDQUFDO2dCQUN0QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87Z0JBQ3JDLHVCQUF1QixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtnQkFDaEQsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXO2dCQUM5QyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxTQUFTLEVBQUU7Z0JBQzlFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtnQkFDNUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7Z0JBQzdELEdBQUcsb0NBQTRCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQzthQUM5QyxDQUFDO1NBQ0wsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQTFCRCw0Q0EwQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QsIER1cmF0aW9uIH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb250YWluZXJEZWZpbml0aW9uIH0gZnJvbSAnLi4vY29udGFpbmVyLWRlZmluaXRpb24nO1xuaW1wb3J0IHsgQmFzZUxvZ0RyaXZlclByb3BzIH0gZnJvbSAnLi9iYXNlLWxvZy1kcml2ZXInO1xuaW1wb3J0IHsgTG9nRHJpdmVyLCBMb2dEcml2ZXJDb25maWcgfSBmcm9tICcuL2xvZy1kcml2ZXInO1xuaW1wb3J0IHsgcmVuZGVyQ29tbW9uTG9nRHJpdmVyT3B0aW9ucywgc3RyaW5naWZ5T3B0aW9ucyB9IGZyb20gJy4vdXRpbHMnO1xuLyoqXG4gKiBTcGVjaWZpZXMgdGhlIGZsdWVudGQgbG9nIGRyaXZlciBjb25maWd1cmF0aW9uIG9wdGlvbnMuXG4gKlxuICogW1NvdXJjZV0oaHR0cHM6Ly9kb2NzLmRvY2tlci5jb20vY29uZmlnL2NvbnRhaW5lcnMvbG9nZ2luZy9mbHVlbnRkLylcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBGbHVlbnRkTG9nRHJpdmVyUHJvcHMgZXh0ZW5kcyBCYXNlTG9nRHJpdmVyUHJvcHMge1xuICAgIC8qKlxuICAgICAqIEJ5IGRlZmF1bHQsIHRoZSBsb2dnaW5nIGRyaXZlciBjb25uZWN0cyB0byBsb2NhbGhvc3Q6MjQyMjQuIFN1cHBseSB0aGVcbiAgICAgKiBhZGRyZXNzIG9wdGlvbiB0byBjb25uZWN0IHRvIGEgZGlmZmVyZW50IGFkZHJlc3MuIHRjcChkZWZhdWx0KSBhbmQgdW5peFxuICAgICAqIHNvY2tldHMgYXJlIHN1cHBvcnRlZC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gYWRkcmVzcyBub3Qgc2V0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFkZHJlc3M/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogRG9ja2VyIGNvbm5lY3RzIHRvIEZsdWVudGQgaW4gdGhlIGJhY2tncm91bmQuIE1lc3NhZ2VzIGFyZSBidWZmZXJlZCB1bnRpbFxuICAgICAqIHRoZSBjb25uZWN0aW9uIGlzIGVzdGFibGlzaGVkLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFzeW5jQ29ubmVjdD86IGJvb2xlYW47XG4gICAgLyoqXG4gICAgICogVGhlIGFtb3VudCBvZiBkYXRhIHRvIGJ1ZmZlciBiZWZvcmUgZmx1c2hpbmcgdG8gZGlzay5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gVGhlIGFtb3VudCBvZiBSQU0gYXZhaWxhYmxlIHRvIHRoZSBjb250YWluZXIuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYnVmZmVyTGltaXQ/OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogSG93IGxvbmcgdG8gd2FpdCBiZXR3ZWVuIHJldHJpZXMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIDEgc2Vjb25kXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmV0cnlXYWl0PzogRHVyYXRpb247XG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gbnVtYmVyIG9mIHJldHJpZXMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIDQyOTQ5NjcyOTUgKDIqKjMyIC0gMSkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4UmV0cmllcz86IG51bWJlcjtcbiAgICAvKipcbiAgICAgKiBHZW5lcmF0ZXMgZXZlbnQgbG9ncyBpbiBuYW5vc2Vjb25kIHJlc29sdXRpb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3ViU2Vjb25kUHJlY2lzaW9uPzogYm9vbGVhbjtcbn1cbi8qKlxuICogQSBsb2cgZHJpdmVyIHRoYXQgc2VuZHMgbG9nIGluZm9ybWF0aW9uIHRvIGpvdXJuYWxkIExvZ3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBGbHVlbnRkTG9nRHJpdmVyIGV4dGVuZHMgTG9nRHJpdmVyIHtcbiAgICAvKipcbiAgICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBGbHVlbnRkTG9nRHJpdmVyIGNsYXNzLlxuICAgICAqXG4gICAgICogQHBhcmFtIHByb3BzIHRoZSBmbHVlbnRkIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiBvcHRpb25zLlxuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEZsdWVudGRMb2dEcml2ZXJQcm9wcyA9IHt9KSB7XG4gICAgICAgIHN1cGVyKCk7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIENhbGxlZCB3aGVuIHRoZSBsb2cgZHJpdmVyIGlzIGNvbmZpZ3VyZWQgb24gYSBjb250YWluZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgX2NvbnRhaW5lckRlZmluaXRpb246IENvbnRhaW5lckRlZmluaXRpb24pOiBMb2dEcml2ZXJDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbG9nRHJpdmVyOiAnZmx1ZW50ZCcsXG4gICAgICAgICAgICBvcHRpb25zOiBzdHJpbmdpZnlPcHRpb25zKHtcbiAgICAgICAgICAgICAgICAnZmx1ZW50ZC1hZGRyZXNzJzogdGhpcy5wcm9wcy5hZGRyZXNzLFxuICAgICAgICAgICAgICAgICdmbHVlbnRkLWFzeW5jLWNvbm5lY3QnOiB0aGlzLnByb3BzLmFzeW5jQ29ubmVjdCxcbiAgICAgICAgICAgICAgICAnZmx1ZW50ZC1idWZmZXItbGltaXQnOiB0aGlzLnByb3BzLmJ1ZmZlckxpbWl0LFxuICAgICAgICAgICAgICAgICdmbHVlbnRkLXJldHJ5LXdhaXQnOiB0aGlzLnByb3BzLnJldHJ5V2FpdCAmJiB0aGlzLnByb3BzLnJldHJ5V2FpdC50b1NlY29uZHMoKSxcbiAgICAgICAgICAgICAgICAnZmx1ZW50ZC1tYXgtcmV0cmllcyc6IHRoaXMucHJvcHMubWF4UmV0cmllcyxcbiAgICAgICAgICAgICAgICAnZmx1ZW50ZC1zdWItc2Vjb25kLXByZWNpc2lvbic6IHRoaXMucHJvcHMuc3ViU2Vjb25kUHJlY2lzaW9uLFxuICAgICAgICAgICAgICAgIC4uLnJlbmRlckNvbW1vbkxvZ0RyaXZlck9wdGlvbnModGhpcy5wcm9wcyksXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=