"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logs = require("../../../aws-logs"); // Automatically re-written from '@aws-cdk/aws-logs'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to CloudWatch Logs.
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(scope, containerDefinition) {
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': core_1.Stack.of(containerDefinition).region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
//# sourceMappingURL=data:application/json;base64,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