"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const region_info_1 = require("../../region-info"); // Automatically re-written from '@aws-cdk/region-info'
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 * @experimental
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired !== undefined ? props.acceptanceRequired : true;
        this.whitelistedPrincipals = props.whitelistedPrincipals !== undefined ? props.whitelistedPrincipals : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ? (_a = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _a !== void 0 ? _a : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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