"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
async function onEventHandler(event) {
    console.log('Event: %j', event);
    /**
     * Process only Create and Delete requests. We shouldn't receive any
     * update request and in case we do there is nothing to update.
     */
    if (event.RequestType === 'Create' || event.RequestType === 'Delete') {
        const dynamodb = new aws_sdk_1.DynamoDB();
        const data = await dynamodb.updateTable({
            TableName: event.ResourceProperties.TableName,
            ReplicaUpdates: [
                {
                    [event.RequestType]: {
                        RegionName: event.ResourceProperties.Region,
                    },
                },
            ],
        }).promise();
        console.log('Update table: %j', data);
    }
    return { PhysicalResourceId: event.ResourceProperties.Region };
}
exports.onEventHandler = onEventHandler;
async function isCompleteHandler(event) {
    var _a, _b, _c;
    console.log('Event: %j', event);
    const dynamodb = new aws_sdk_1.DynamoDB();
    const data = await dynamodb.describeTable({
        TableName: event.ResourceProperties.TableName,
    }).promise();
    console.log('Describe table: %j', data);
    const tableActive = !!(((_a = data.Table) === null || _a === void 0 ? void 0 : _a.TableStatus) === 'ACTIVE');
    const replicas = (_c = (_b = data.Table) === null || _b === void 0 ? void 0 : _b.Replicas) !== null && _c !== void 0 ? _c : [];
    const regionReplica = replicas.find(r => r.RegionName === event.ResourceProperties.Region);
    const replicaActive = !!((regionReplica === null || regionReplica === void 0 ? void 0 : regionReplica.ReplicaStatus) === 'ACTIVE');
    switch (event.RequestType) {
        case 'Create':
        case 'Update':
            // Complete when replica is reported as ACTIVE
            return { IsComplete: tableActive && replicaActive };
        case 'Delete':
            // Complete when replica is gone
            return { IsComplete: tableActive && regionReplica === undefined };
    }
}
exports.isCompleteHandler = isCompleteHandler;
//# sourceMappingURL=data:application/json;base64,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